IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_REMOVE_EST_PROD]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_REMOVE_EST_PROD]
GO

CREATE PROCEDURE P_REMOVE_EST_PROD ( @CD_EMP INT=1, @CD_PROD INT )
AS
SET NOCOUNT ON

DECLARE @ErrorMessage Varchar(2000);
DECLARE @ErrorTable Varchar(2000);
DECLARE @ErrorSeverity INT=16;
DECLARE @ErrorState INT=1;


IF EXISTS(SELECT TOP 1 CD_EMP FROM PDV_VD_IT
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com venda efetuada.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_NF_ENT_IT
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com nota de entrada efetivada.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_NF_SAI_IT
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com nota de saida emitida.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_PROD_IMP
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com ajuste de estoque efetivado.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_PED_CP_IT
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com pedido compra emitido.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_PED_VD_IT
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com pedido venda emitido.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END

IF EXISTS(SELECT TOP 1 CD_EMP FROM EST_PROD_INVENTARIO
WHERE
CD_EMP=@CD_EMP
AND CD_PROD= @CD_PROD)
BEGIN
SELECT @ErrorMessage = 'Produto com Inventario realizado.',
@ErrorSeverity = 16,
@ErrorState =1;
GOTO TrataErro
END
/*********************************************************************************************************/
-- Exclusao dos registros
/*********************************************************************************************************/

BEGIN TRY

set @ErrorTable='CG_FND_VERBA_PROD'
DELETE FROM CG_FND_VERBA_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_ALCADA_CP_COB_CURVA_EST_PROD'
DELETE FROM EST_ALCADA_CP_COB_CURVA_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_CPH_PATROCINIO_EST_PROD'
DELETE FROM EST_CPH_PATROCINIO_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_DESC_CONV_PROD_EST_PROD'
DELETE FROM EST_DESC_CONV_PROD_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_EQUIPA_CPL_EST_PROD'
DELETE FROM EST_EQUIPA_CPL_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_EXPOSICAO_EST_PROD'
DELETE FROM EST_EXPOSICAO_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_GRP_COMIS_EST_PROD'
DELETE FROM EST_GRP_COMIS_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_DANFE_PROVISORIO_ITENS'
DELETE FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO'
DELETE FROM EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_PRE_ENTRADA_CONF_FASES_ITENS'
DELETE FROM EST_NF_ENT_PRE_ENTRADA_CONF_FASES_ITENS WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_PRE_ENTRADA_CPL'
DELETE FROM EST_NF_ENT_PRE_ENTRADA_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_PRE_ENTRADA_CPL_CONF'
DELETE FROM EST_NF_ENT_PRE_ENTRADA_CPL_CONF WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_ENT_PRE_ENTRADA_CPL_LOTE'
DELETE FROM EST_NF_ENT_PRE_ENTRADA_CPL_LOTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_SAI_CHECKIN_ENTRADA_CPL'
DELETE FROM EST_NF_SAI_CHECKIN_ENTRADA_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_NF_SAI_CHECKIN_ENTRADA_CPL_EST_PROD_CPL_LOTE'
DELETE FROM EST_NF_SAI_CHECKIN_ENTRADA_CPL_EST_PROD_CPL_LOTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_OPERADORA_CELULAR_EST_PROD'
DELETE FROM EST_OPERADORA_CELULAR_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_ORC_CPL_FALTA'
DELETE FROM EST_ORC_CPL_FALTA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PBM_PROJETO_EST_PROD'
DELETE FROM EST_PBM_PROJETO_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PED_ELTR_COT_COMPRA_RET'
DELETE FROM EST_PED_ELTR_COT_COMPRA_RET WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PED_ELTR_COT_MOV_RES'
DELETE FROM EST_PED_ELTR_COT_MOV_RES WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PED_ELTR_COT_VIGENTE'
DELETE FROM EST_PED_ELTR_COT_VIGENTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PED_ELTR_IT'
DELETE FROM EST_PED_ELTR_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CD_BARRA'
DELETE FROM EST_PROD_CD_BARRA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_COMP'
DELETE FROM EST_PROD_COMP WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_COND_CP_PG_FORN'
DELETE FROM EST_PROD_COND_CP_PG_FORN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_COND_CP_PG_FORN_VIGENTE'
DELETE FROM EST_PROD_COND_CP_PG_FORN_VIGENTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_IMP_PLU'
DELETE FROM EST_PROD_CPL_IMP_PLU WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_DESC_COMERCIAL'
DELETE FROM EST_PROD_DESC_COMERCIAL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_DESC_FINAN'
DELETE FROM EST_PROD_DESC_FINAN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_DETE_IT'
DELETE FROM EST_PROD_DETE_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_ENT_GRP_ECON'
DELETE FROM EST_PROD_ENT_GRP_ECON WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_PROD_CLASSE'
DELETE FROM EST_PROD_EST_PROD_CLASSE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_PROD_GEN_NCM'
DELETE FROM EST_PROD_EST_PROD_GEN_NCM WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_PROD_TRANSF_SC_ESPECIAL'
DELETE FROM EST_PROD_EST_PROD_TRANSF_SC_ESPECIAL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_SNGPC'
DELETE FROM EST_PROD_EST_SNGPC WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL'
DELETE FROM EST_PROD_EST_TRIB_CLASS_FISC_PRC_REGIAO_FISCAL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_TRIB_CONF_GRP'
DELETE FROM EST_PROD_EST_TRIB_CONF_GRP WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_TRIB_CONF_GRP_PG_FORN'
DELETE FROM EST_PROD_EST_TRIB_CONF_GRP_PG_FORN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_FARMACIA_POPULAR'
DELETE FROM EST_PROD_FARMACIA_POPULAR WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_FORN'
DELETE FROM EST_PROD_FORN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_FORN_PERC_DESC'
DELETE FROM EST_PROD_FORN_PERC_DESC WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_FORN_SUBST_ZERADO'
DELETE FROM EST_PROD_FORN_SUBST_ZERADO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_GRP_CONTAGEM_CPL'
DELETE FROM EST_PROD_GRP_CONTAGEM_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_INF_DIVERS'
DELETE FROM EST_PROD_INF_DIVERS WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_INTEGRACAO_ENVIO_PENDENTE'
DELETE FROM EST_PROD_INTEGRACAO_ENVIO_PENDENTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_KIT_CPL'
DELETE FROM EST_PROD_KIT_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_KIT_CPL'
DELETE FROM EST_PROD_KIT_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD_KIT= @CD_PROD;
set @ErrorTable='EST_PROD_KIT_REPLIC'
DELETE FROM EST_PROD_KIT_REPLIC WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_KIT_REPLIC'
DELETE FROM EST_PROD_KIT_REPLIC WHERE CD_EMP=@CD_EMP AND CD_PROD_KIT_REPLIC= @CD_PROD;
set @ErrorTable='EST_PROD_KIT'
DELETE FROM EST_PROD_KIT WHERE CD_EMP=@CD_EMP AND CD_PROD_KIT= @CD_PROD;
set @ErrorTable='EST_PROD_KIT'
DELETE FROM EST_PROD_KIT WHERE CD_EMP=@CD_EMP AND CD_PROD_KIT_REPLIC= @CD_PROD;
set @ErrorTable='EST_PROD_LIST_GENEXIS'
DELETE FROM EST_PROD_LIST_GENEXIS WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PLU'
DELETE FROM EST_PROD_PLU WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_EST_TRIB_CONF_GRP'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_EST_TRIB_CONF_GRP WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_EST_TRIB_CONF_GRP_PG_FORN'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_EST_TRIB_CONF_GRP_PG_FORN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_PEND'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_TRIB_EST_PEND WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_TRIB_FORN'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_TRIB_FORN WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER_DAR'
DELETE FROM EST_PROD_PRC_REGIAO_FISCAL_TRIB_INTER_DAR WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECIFICACAO_BLOQUEIOS'
DELETE FROM EST_PROD_PRECIFICACAO_BLOQUEIOS WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_CONV_PROD_EST_PROD'
																			   
													 
DELETE FROM EST_PROD_PRECO_CONV_PROD_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_DESC_ANIVER_CPL'
DELETE FROM EST_PROD_PRECO_DESC_ANIVER_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL'
DELETE FROM EST_PROD_PRECO_DESC_CLAS_CLIENTE_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_DESC_PRG_CPL'
DELETE FROM EST_PROD_PRECO_DESC_PRG_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_DESC_QTDE_CPL'
DELETE FROM EST_PROD_PRECO_DESC_QTDE_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_GRP_FIDEL_EST_PROD'
DELETE FROM EST_PROD_PRECO_GRP_FIDEL_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_PESQ_MERC_ANALISE'
DELETE FROM EST_PROD_PRECO_PESQ_MERC_ANALISE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_PESQ_MERC_IT'
DELETE FROM EST_PROD_PRECO_PESQ_MERC_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_PESQ_MERC_PROPRIO'
DELETE FROM EST_PROD_PRECO_PESQ_MERC_PROPRIO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_TBL'
DELETE FROM EST_PROD_PRECO_TBL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_TBL_HIST_CPL'
DELETE FROM EST_PROD_PRECO_TBL_HIST_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRINC_ATIVOS_EST_PROD'
DELETE FROM EST_PROD_PRINC_ATIVOS_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PROMO_CPL'
DELETE FROM EST_PROD_PROMO_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_RC_CLI_CONV'
DELETE FROM EST_PROD_RC_CLI_CONV WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_RC_CLI_ULT_CP'
DELETE FROM EST_PROD_RC_CLI_ULT_CP WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_REF'
DELETE FROM EST_PROD_REF WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_REFERENCIA'
DELETE FROM EST_PROD_REFERENCIA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_REFERENCIA'
DELETE FROM EST_PROD_REFERENCIA WHERE CD_EMP=@CD_EMP AND CD_PROD_REFERENCIA= @CD_PROD;
set @ErrorTable='EST_PROD_REQ_ETQ_CPL'
DELETE FROM EST_PROD_REQ_ETQ_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_REQ_TRANSF_CENTRO_CUSTO_CPL'
DELETE FROM EST_PROD_REQ_TRANSF_CENTRO_CUSTO_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_REQ_TRANSF_CENTRO_CUSTO_LIB_CPL'
DELETE FROM EST_PROD_REQ_TRANSF_CENTRO_CUSTO_LIB_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_SAZONALIDADE'
DELETE FROM EST_PROD_SAZONALIDADE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_TBL_COMIS_EST_PROD'
DELETE FROM EST_PROD_TBL_COMIS_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_TBL_DESC_CARGO_EST_PROD'
DELETE FROM EST_PROD_TBL_DESC_CARGO_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_TBL_DESC_EST_PROD'
DELETE FROM EST_PROD_TBL_DESC_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_TBL_DESC_QTDE_EST_PROD'
DELETE FROM EST_PROD_TBL_DESC_QTDE_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_TBL_FIDEL_EST_PROD'
DELETE FROM EST_PROD_TBL_FIDEL_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_TOP_SHOW_EST_PROD'
DELETE FROM EST_TOP_SHOW_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_WMS_ENT_IT'
DELETE FROM EST_WMS_ENT_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_WMS_ENT_RET'
DELETE FROM EST_WMS_ENT_RET WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_WMS_SAI_IT'
DELETE FROM EST_WMS_SAI_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_WMS_SAI_RET'
DELETE FROM EST_WMS_SAI_RET WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_WMS_SAI_VOLUME_IT'
DELETE FROM EST_WMS_SAI_VOLUME_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='GLB_OPER_CEL'
DELETE FROM GLB_OPER_CEL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='PDV_CAMPANHA_ADICIONAIS_EST_PROD'
DELETE FROM PDV_CAMPANHA_ADICIONAIS_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA'
DELETE FROM PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD'
DELETE FROM PRC_FILIAL_DEPOSITO_AUXILIAR_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD'
DELETE FROM RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='RC_CLI_EST_PROD'
DELETE FROM RC_CLI_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='RC_CLI_EST_PROD_CONTINUO'
DELETE FROM RC_CLI_EST_PROD_CONTINUO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='RC_CLI_FIDELI_PONTOS_EST_PROD_PARA_TROCA'
DELETE FROM RC_CLI_FIDELI_PONTOS_EST_PROD_PARA_TROCA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='SNGPC_EST_PROD'
DELETE FROM SNGPC_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='SNGPC_EST_PROD_CPL'
DELETE FROM SNGPC_EST_PROD_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='TLV_CAMPANHA_IT1'
DELETE FROM TLV_CAMPANHA_IT1 WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='TLV_MSG_EST_PROD'
DELETE FROM TLV_MSG_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='TLV_PED_VD_IT'
DELETE FROM TLV_PED_VD_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='TLV_PROD_FAMILIA_EST_PROD'
DELETE FROM TLV_PROD_FAMILIA_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PARAM_COMPRAS_PERFIL_EST_PROD'
DELETE FROM EST_PARAM_COMPRAS_PERFIL_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_EST_ARV_MERCADOLOGICA'
DELETE FROM EST_PROD_EST_ARV_MERCADOLOGICA WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD'
DELETE FROM EST_PARAM_COMPRAS_PERFIL_LOTE_TRANSACAO_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_AGENDA_COMPRA_EST_PROD'
DELETE FROM EST_PROD_AGENDA_COMPRA_EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
 
 
																																												 

/*************************************************************************************************/
																			   
												   
																					 
														  
																						   
										 
																		  
										 
																		  
									   
																			
									   
																			
								  
																											
											 
																				   

set @ErrorTable='EST_GRP_COMIS_PDV_CPL'
DELETE FROM EST_GRP_COMIS_PDV_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_BLOQUEIO_AUDIT'
DELETE FROM EST_PROD_CPL_BLOQUEIO_AUDIT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_CUSTO_ZERADO_PENDENTE'
DELETE FROM EST_PROD_CPL_CUSTO_ZERADO_PENDENTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_BALAN_IT'
DELETE FROM EST_PROD_BALAN_IT WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_NASC'
DELETE FROM EST_PROD_CPL_NASC WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_MEDIAP'
DELETE FROM EST_PROD_CPL_MEDIAP WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_CPL_MEDIAF'
DELETE FROM EST_PROD_CPL_MEDIAF WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;

set @ErrorTable='EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE'
DELETE FROM EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_ALT_CPL_LIB'
DELETE FROM EST_PROD_PRECO_ALT_CPL_LIB WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO_ALT_CPL'
DELETE FROM EST_PROD_PRECO_ALT_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
set @ErrorTable='EST_PROD_PRECO'
DELETE FROM EST_PROD_PRECO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;

set @ErrorTable='EST_PROD_CPL_ACERTO_CUSTO'
DELETE FROM EST_PROD_CPL_ACERTO_CUSTO WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;

set @ErrorTable='EST_PROD_CPL'
DELETE FROM EST_PROD_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;

/*************************************************************************************************/

SET @ErrorTable='EST_PROD'
DELETE FROM EST_PROD WHERE CD_EMP=@CD_EMP AND CD_PROD= @CD_PROD;
Return;

/*************************************************************************************************/
END TRY
BEGIN CATCH
select
@ErrorMessage = ERROR_MESSAGE (),
@ErrorSeverity=ERROR_SEVERITY (),
@ErrorState=ERROR_STATE ();
Goto TrataErro
END CATCH

TrataErro:
set @ErrorMessage = ISNULL(@ErrorTable,'')+ ' ' + @ErrorMessage ;
  
													  
		

RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState);
RETURN;

/*********************************************************************************************************/